package com.v8pay.test;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Objects;


public class Main {

    public static void main(String[] args) {
        String checksum = "aa687f2b8a3da2e32312149b8b17f75be0520ca900530275b438c6331556bd8c92370b21e5**** CHECKSUM *****";
        String iv = "Yb9EyHhusr**** IV *****";
        String key = "eRO09XoKURfLgQ**** YOUR AES Secret key *****"; // From setting page on V8pay
        String md5 = "22b76120fff3b3ee**** MD5 *****";
        String result = decrypt(checksum, iv, key);
        if (Objects.equals(result, md5)) {
            System.out.println("Validation successfully!");
        } else {
            System.out.println("Validation fail!");
        }
    }

    public static String decrypt(String encrypted, String iv, String key) {
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");

            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(Cipher.DECRYPT_MODE, skeySpec, ivSpec);
            byte[] original = cipher.doFinal(hexStringToByteArray(encrypted));

            return new String(original);
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return null;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4)
                    + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}
